// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_IPHONE_STATUS_CALLBACKS_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_IPHONE_STATUS_CALLBACKS_H

#include "common.h"

/**
 * Contains information about a single call.
 */
struct Call {
    uint32_t state; /**< What state the call is in. */
    string caller_number; /**< The phone number of the caller. */
    string caller_id; /**< The caller id. */
    string caller_number_type; /**< The type the number is. Eg: Home, Mobile, Work, ... */
    uint32_t call_duration_seconds; /**< Current duration of the call in seconds. */
    string caller_thumbnail; /**< A PNG thumbnail of the caller. */
};

/**
 * Used to communicate phone status to the receiver library.
 */
struct PhoneStatusStruct {
    Call* calls; /**< Array of all current calls. */
    uint32_t num_calls; /**< Number of current on going calls. */
    uint32_t signal_strength; /**< Relative signal strength from 0-100. */
};

/**
 * This class represents an interface that every sink implementation must subclass if they wish to
 * implement the part of the GAL protocol that receives phone status. You should also take
 * a look at the class PhoneStatusEndpoint for a pseudocode example.
 */
class IPhoneStatusCallbacks {
public:
    virtual ~IPhoneStatusCallbacks() { }

    /**
     * Called when phone status message comes through.
     */
    virtual void phoneStatusCallback(const struct PhoneStatusStruct& status) = 0;
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_IPHONE_STATUS_CALLBACKS_H
